<?php
require_once '../config.php';
checkAuth();

header('Content-Type: application/json');

// Get request method
$method = $_SERVER['REQUEST_METHOD'];

switch ($method) {
    case 'GET':
        // Get all customers or a specific customer
        if (isset($_GET['id'])) {
            try {
                $stmt = $db->prepare("SELECT * FROM customers WHERE id = ?");
                $stmt->execute([$_GET['id']]);
                $customer = $stmt->fetch(PDO::FETCH_ASSOC);
                echo json_encode($customer);
            } catch(PDOException $e) {
                http_response_code(500);
                echo json_encode(['error' => $e->getMessage()]);
            }
        } else {
            try {
                $stmt = $db->query("SELECT * FROM customers ORDER BY company_name");
                $customers = $stmt->fetchAll(PDO::FETCH_ASSOC);
                echo json_encode($customers);
            } catch(PDOException $e) {
                http_response_code(500);
                echo json_encode(['error' => $e->getMessage()]);
            }
        }
        break;

    case 'POST':
        // Create new customer
        $data = json_decode(file_get_contents('php://input'), true);
        
        try {
            $stmt = $db->prepare("
                INSERT INTO customers (company_name, contact_name, email, phone, address)
                VALUES (?, ?, ?, ?, ?)
            ");
            
            $stmt->execute([
                $data['company_name'],
                $data['contact_name'],
                $data['email'],
                $data['phone'],
                $data['address'] ?? null
            ]);
            
            echo json_encode(['id' => $db->lastInsertId()]);
        } catch(PDOException $e) {
            http_response_code(500);
            echo json_encode(['error' => $e->getMessage()]);
        }
        break;

    case 'PUT':
        // Update customer
        $data = json_decode(file_get_contents('php://input'), true);
        
        try {
            $stmt = $db->prepare("
                UPDATE customers 
                SET company_name = ?, contact_name = ?, email = ?, phone = ?, address = ?
                WHERE id = ?
            ");
            
            $stmt->execute([
                $data['company_name'],
                $data['contact_name'],
                $data['email'],
                $data['phone'],
                $data['address'] ?? null,
                $data['id']
            ]);
            
            echo json_encode(['success' => true]);
        } catch(PDOException $e) {
            http_response_code(500);
            echo json_encode(['error' => $e->getMessage()]);
        }
        break;

    case 'DELETE':
        // Delete customer
        $id = $_GET['id'] ?? null;
        
        if ($id) {
            try {
                $stmt = $db->prepare("DELETE FROM customers WHERE id = ?");
                $stmt->execute([$id]);
                echo json_encode(['success' => true]);
            } catch(PDOException $e) {
                http_response_code(500);
                echo json_encode(['error' => $e->getMessage()]);
            }
        } else {
            http_response_code(400);
            echo json_encode(['error' => 'ID parameter is required']);
        }
        break;

    default:
        http_response_code(405);
        echo json_encode(['error' => 'Method not allowed']);
        break;
}
?> 