<?php
require_once '../config.php';
checkAuth();

header('Content-Type: application/json');

// Get request method
$method = $_SERVER['REQUEST_METHOD'];

switch ($method) {
    case 'GET':
        // Get all units or a specific unit
        if (isset($_GET['id'])) {
            try {
                $stmt = $db->prepare("SELECT * FROM advertising_units WHERE id = ?");
                $stmt->execute([$_GET['id']]);
                $unit = $stmt->fetch(PDO::FETCH_ASSOC);
                echo json_encode($unit);
            } catch(PDOException $e) {
                http_response_code(500);
                echo json_encode(['error' => $e->getMessage()]);
            }
        } else {
            try {
                $stmt = $db->query("SELECT * FROM advertising_units ORDER BY type, name");
                $units = $stmt->fetchAll(PDO::FETCH_ASSOC);
                echo json_encode($units);
            } catch(PDOException $e) {
                http_response_code(500);
                echo json_encode(['error' => $e->getMessage()]);
            }
        }
        break;

    case 'POST':
        // Create new unit
        $data = json_decode(file_get_contents('php://input'), true);
        
        try {
            $stmt = $db->prepare("
                INSERT INTO advertising_units (type, name, location, latitude, longitude, description, status)
                VALUES (?, ?, ?, ?, ?, ?, ?)
            ");
            
            $stmt->execute([
                $data['type'],
                $data['name'],
                $data['location'],
                $data['latitude'],
                $data['longitude'],
                $data['description'] ?? null,
                $data['status'] ?? 'available'
            ]);
            
            echo json_encode(['id' => $db->lastInsertId()]);
        } catch(PDOException $e) {
            http_response_code(500);
            echo json_encode(['error' => $e->getMessage()]);
        }
        break;

    case 'PUT':
        // Update unit
        $data = json_decode(file_get_contents('php://input'), true);
        
        try {
            $stmt = $db->prepare("
                UPDATE advertising_units 
                SET type = ?, name = ?, location = ?, latitude = ?, longitude = ?, description = ?, status = ?
                WHERE id = ?
            ");
            
            $stmt->execute([
                $data['type'],
                $data['name'],
                $data['location'],
                $data['latitude'],
                $data['longitude'],
                $data['description'] ?? null,
                $data['status'] ?? 'available',
                $data['id']
            ]);
            
            echo json_encode(['success' => true]);
        } catch(PDOException $e) {
            http_response_code(500);
            echo json_encode(['error' => $e->getMessage()]);
        }
        break;

    case 'DELETE':
        // Delete unit
        $id = $_GET['id'] ?? null;
        
        if ($id) {
            try {
                $stmt = $db->prepare("DELETE FROM advertising_units WHERE id = ?");
                $stmt->execute([$id]);
                echo json_encode(['success' => true]);
            } catch(PDOException $e) {
                http_response_code(500);
                echo json_encode(['error' => $e->getMessage()]);
            }
        } else {
            http_response_code(400);
            echo json_encode(['error' => 'ID parameter is required']);
        }
        break;

    default:
        http_response_code(405);
        echo json_encode(['error' => 'Method not allowed']);
        break;
}
?> 