<?php
require_once 'config.php';
checkAuth();

// Get all customers
try {
    $stmt = $db->query("SELECT * FROM customers ORDER BY company_name");
    $customers = $stmt->fetchAll(PDO::FETCH_ASSOC);
} catch(PDOException $e) {
    echo "Error: " . $e->getMessage();
    $customers = [];
}
?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Müşteriler - <?php echo SITE_NAME; ?></title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/boxicons@2.0.7/css/boxicons.min.css" rel="stylesheet">
    <style>
        .sidebar {
            min-height: 100vh;
            background: #343a40;
            color: white;
        }
        .nav-link {
            color: rgba(255,255,255,.8);
        }
        .nav-link:hover {
            color: white;
        }
        .card {
            border: none;
            border-radius: 10px;
            box-shadow: 0 0 10px rgba(0,0,0,.1);
        }
        .customer-card {
            transition: transform .2s;
        }
        .customer-card:hover {
            transform: translateY(-5px);
        }
    </style>
</head>
<body>
    <div class="container-fluid">
        <div class="row">
            <!-- Sidebar -->
            <div class="col-md-3 col-lg-2 px-0 sidebar">
                <div class="p-3">
                    <h4 class="text-center mb-4"><?php echo SITE_NAME; ?></h4>
                    <ul class="nav flex-column">
                        <li class="nav-item">
                            <a class="nav-link" href="dashboard.php">
                                <i class='bx bxs-dashboard'></i> Dashboard
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="units.php">
                                <i class='bx bxs-map'></i> Reklam Üniteleri
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="reservations.php">
                                <i class='bx bxs-calendar'></i> Rezervasyonlar
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link active" href="customers.php">
                                <i class='bx bxs-user-detail'></i> Müşteriler
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="contracts.php">
                                <i class='bx bxs-file'></i> Sözleşmeler
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="logout.php">
                                <i class='bx bxs-log-out'></i> Çıkış
                            </a>
                        </li>
                    </ul>
                </div>
            </div>

            <!-- Main Content -->
            <div class="col-md-9 col-lg-10 px-4 py-3">
                <div class="d-flex justify-content-between align-items-center mb-4">
                    <h2>Müşteriler</h2>
                    <button class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#addCustomerModal">
                        <i class='bx bx-plus'></i> Yeni Müşteri Ekle
                    </button>
                </div>

                <!-- Customers List -->
                <div class="row">
                    <?php foreach ($customers as $customer): ?>
                    <div class="col-md-4 mb-4">
                        <div class="card customer-card">
                            <div class="card-body">
                                <h5 class="card-title"><?php echo htmlspecialchars($customer['company_name']); ?></h5>
                                <p class="card-text">
                                    <strong>İletişim Kişisi:</strong> <?php echo htmlspecialchars($customer['contact_name']); ?><br>
                                    <strong>E-posta:</strong> <?php echo htmlspecialchars($customer['email']); ?><br>
                                    <strong>Telefon:</strong> <?php echo htmlspecialchars($customer['phone']); ?><br>
                                    <strong>Adres:</strong> <?php echo htmlspecialchars($customer['address']); ?>
                                </p>
                                <div class="btn-group">
                                    <button class="btn btn-sm btn-outline-primary" onclick="editCustomer(<?php echo $customer['id']; ?>)">
                                        <i class='bx bx-edit'></i> Düzenle
                                    </button>
                                    <button class="btn btn-sm btn-outline-danger" onclick="deleteCustomer(<?php echo $customer['id']; ?>)">
                                        <i class='bx bx-trash'></i> Sil
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
                    <?php endforeach; ?>
                </div>
            </div>
        </div>
    </div>

    <!-- Add Customer Modal -->
    <div class="modal fade" id="addCustomerModal" tabindex="-1">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Yeni Müşteri Ekle</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <form id="addCustomerForm">
                        <div class="mb-3">
                            <label class="form-label">Firma Adı</label>
                            <input type="text" class="form-control" name="company_name" required>
                        </div>
                        <div class="mb-3">
                            <label class="form-label">İletişim Kişisi</label>
                            <input type="text" class="form-control" name="contact_name" required>
                        </div>
                        <div class="mb-3">
                            <label class="form-label">E-posta</label>
                            <input type="email" class="form-control" name="email" required>
                        </div>
                        <div class="mb-3">
                            <label class="form-label">Telefon</label>
                            <input type="tel" class="form-control" name="phone" required>
                        </div>
                        <div class="mb-3">
                            <label class="form-label">Adres</label>
                            <textarea class="form-control" name="address" rows="3"></textarea>
                        </div>
                    </form>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">İptal</button>
                    <button type="button" class="btn btn-primary" onclick="saveCustomer()">Kaydet</button>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        // Save customer function
        function saveCustomer() {
            const form = document.getElementById('addCustomerForm');
            const formData = new FormData(form);
            
            fetch('api/customers.php', {
                method: 'POST',
                body: JSON.stringify(Object.fromEntries(formData)),
                headers: {
                    'Content-Type': 'application/json'
                }
            })
            .then(response => response.json())
            .then(data => {
                if (data.id) {
                    location.reload();
                } else {
                    alert('Müşteri eklenirken bir hata oluştu.');
                }
            })
            .catch(error => {
                console.error('Error:', error);
                alert('Müşteri eklenirken bir hata oluştu.');
            });
        }

        // Edit customer function
        function editCustomer(id) {
            // Add edit functionality
        }

        // Delete customer function
        function deleteCustomer(id) {
            if (confirm('Bu müşteriyi silmek istediğinizden emin misiniz?')) {
                fetch(`api/customers.php?id=${id}`, {
                    method: 'DELETE'
                })
                .then(response => response.json())
                .then(data => {
                    if (data.success) {
                        location.reload();
                    } else {
                        alert('Müşteri silinirken bir hata oluştu.');
                    }
                })
                .catch(error => {
                    console.error('Error:', error);
                    alert('Müşteri silinirken bir hata oluştu.');
                });
            }
        }
    </script>
</body>
</html> 