<?php
session_start();

// Kurulum tamamlandıysa ana sayfaya yönlendir
if (file_exists('config.php') && !isset($_GET['force'])) {
    header('Location: index.php');
    exit;
}

$step = isset($_GET['step']) ? (int)$_GET['step'] : 1;
$error = '';
$success = '';

// Kurulum adımları
switch ($step) {
    case 1: // Sistem gereksinimleri kontrolü
        $requirements = [
            'PHP Sürümü (>= 7.4)' => version_compare(PHP_VERSION, '7.4.0', '>='),
            'PDO MySQL' => extension_loaded('pdo_mysql'),
            'GD Kütüphanesi' => extension_loaded('gd'),
            'uploads/ Klasörü Yazılabilir' => is_writable('uploads') || @mkdir('uploads', 0777, true),
            'config.php Yazılabilir' => !file_exists('config.php') || is_writable('config.php')
        ];
        
        $canProceed = !in_array(false, $requirements);
        break;
        
    case 2: // Veritabanı ayarları
        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            $db_host = $_POST['db_host'] ?? '';
            $db_name = $_POST['db_name'] ?? '';
            $db_user = $_POST['db_user'] ?? '';
            $db_pass = $_POST['db_pass'] ?? '';
            
            try {
                // Veritabanı bağlantısını test et
                $db = new PDO("mysql:host=$db_host", $db_user, $db_pass);
                $db->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
                
                // Veritabanını oluştur
                $db->exec("CREATE DATABASE IF NOT EXISTS `$db_name` CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci");
                $db->exec("USE `$db_name`");
                
                // Tabloları oluştur
                $sql_files = [
                    'sql/users.sql',
                    'sql/advertising_units.sql',
                    'sql/customers.sql',
                    'sql/reservations.sql',
                    'sql/contracts.sql',
                    'sql/payments.sql'
                ];
                
                foreach ($sql_files as $file) {
                    if (file_exists($file)) {
                        $sql = file_get_contents($file);
                        $db->exec($sql);
                    }
                }
                
                // Config dosyasını oluştur
                $config_content = "<?php
define('DB_HOST', '$db_host');
define('DB_NAME', '$db_name');
define('DB_USER', '$db_user');
define('DB_PASS', '$db_pass');
define('SITE_NAME', 'Reklam Yönetim Sistemi');
define('SITE_URL', 'http://' . \$_SERVER['HTTP_HOST'] . dirname(\$_SERVER['PHP_SELF']));
";
                file_put_contents('config.php', $config_content);
                
                $_SESSION['install_step'] = 3;
                header('Location: install.php?step=3');
                exit;
            } catch (PDOException $e) {
                $error = 'Veritabanı bağlantı hatası: ' . $e->getMessage();
            }
        }
        break;
        
    case 3: // Admin hesabı oluşturma
        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            $username = $_POST['username'] ?? '';
            $password = $_POST['password'] ?? '';
            $email = $_POST['email'] ?? '';
            
            if (empty($username) || empty($password) || empty($email)) {
                $error = 'Tüm alanları doldurun';
            } else {
                try {
                    require_once 'config.php';
                    $db = new PDO("mysql:host=" . DB_HOST . ";dbname=" . DB_NAME, DB_USER, DB_PASS);
                    $db->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
                    
                    // Admin kullanıcısını oluştur
                    $stmt = $db->prepare("INSERT INTO users (username, password, email, role, status) VALUES (?, ?, ?, 'admin', 'active')");
                    $stmt->execute([$username, password_hash($password, PASSWORD_DEFAULT), $email]);
                    
                    $_SESSION['install_step'] = 4;
                    header('Location: install.php?step=4');
                    exit;
                } catch (PDOException $e) {
                    $error = 'Kullanıcı oluşturma hatası: ' . $e->getMessage();
                }
            }
        }
        break;
        
    case 4: // Kurulum tamamlandı
        $success = 'Kurulum başarıyla tamamlandı!';
        break;
}
?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Kurulum Sihirbazı - Reklam Yönetim Sistemi</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body {
            background-color: #f8f9fa;
        }
        .install-container {
            max-width: 800px;
            margin: 50px auto;
            background: white;
            padding: 30px;
            border-radius: 10px;
            box-shadow: 0 0 20px rgba(0,0,0,.1);
        }
        .step-indicator {
            margin-bottom: 30px;
        }
        .step-indicator .step {
            width: 30px;
            height: 30px;
            border-radius: 50%;
            background: #e9ecef;
            display: inline-flex;
            align-items: center;
            justify-content: center;
            margin: 0 10px;
            position: relative;
        }
        .step-indicator .step.active {
            background: #0d6efd;
            color: white;
        }
        .step-indicator .step.completed {
            background: #198754;
            color: white;
        }
        .step-indicator .step:not(:last-child):after {
            content: '';
            position: absolute;
            right: -20px;
            top: 50%;
            width: 20px;
            height: 2px;
            background: #e9ecef;
        }
    </style>
</head>
<body>
    <div class="install-container">
        <h2 class="text-center mb-4">Reklam Yönetim Sistemi Kurulum Sihirbazı</h2>
        
        <!-- Step Indicator -->
        <div class="step-indicator text-center">
            <div class="step <?php echo $step >= 1 ? 'active' : ''; ?>">1</div>
            <div class="step <?php echo $step >= 2 ? 'active' : ''; ?>">2</div>
            <div class="step <?php echo $step >= 3 ? 'active' : ''; ?>">3</div>
            <div class="step <?php echo $step >= 4 ? 'active' : ''; ?>">4</div>
        </div>
        
        <?php if ($error): ?>
        <div class="alert alert-danger"><?php echo $error; ?></div>
        <?php endif; ?>
        
        <?php if ($success): ?>
        <div class="alert alert-success"><?php echo $success; ?></div>
        <?php endif; ?>
        
        <!-- Step Content -->
        <?php if ($step === 1): ?>
        <div class="card">
            <div class="card-body">
                <h5 class="card-title">Sistem Gereksinimleri</h5>
                <table class="table">
                    <tbody>
                        <?php foreach ($requirements as $requirement => $met): ?>
                        <tr>
                            <td><?php echo $requirement; ?></td>
                            <td>
                                <?php if ($met): ?>
                                <span class="badge bg-success">Tamam</span>
                                <?php else: ?>
                                <span class="badge bg-danger">Eksik</span>
                                <?php endif; ?>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
                
                <?php if ($canProceed): ?>
                <a href="?step=2" class="btn btn-primary">Devam Et</a>
                <?php else: ?>
                <div class="alert alert-warning">
                    Lütfen eksik gereksinimleri tamamlayın ve sayfayı yenileyin.
                </div>
                <?php endif; ?>
            </div>
        </div>
        
        <?php elseif ($step === 2): ?>
        <div class="card">
            <div class="card-body">
                <h5 class="card-title">Veritabanı Ayarları</h5>
                <form method="post">
                    <div class="mb-3">
                        <label class="form-label">Veritabanı Sunucusu</label>
                        <input type="text" class="form-control" name="db_host" value="localhost" required>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Veritabanı Adı</label>
                        <input type="text" class="form-control" name="db_name" required>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Veritabanı Kullanıcısı</label>
                        <input type="text" class="form-control" name="db_user" required>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Veritabanı Şifresi</label>
                        <input type="password" class="form-control" name="db_pass" required>
                    </div>
                    <button type="submit" class="btn btn-primary">Devam Et</button>
                </form>
            </div>
        </div>
        
        <?php elseif ($step === 3): ?>
        <div class="card">
            <div class="card-body">
                <h5 class="card-title">Admin Hesabı Oluştur</h5>
                <form method="post">
                    <div class="mb-3">
                        <label class="form-label">Kullanıcı Adı</label>
                        <input type="text" class="form-control" name="username" required>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">E-posta</label>
                        <input type="email" class="form-control" name="email" required>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Şifre</label>
                        <input type="password" class="form-control" name="password" required>
                    </div>
                    <button type="submit" class="btn btn-primary">Devam Et</button>
                </form>
            </div>
        </div>
        
        <?php elseif ($step === 4): ?>
        <div class="card">
            <div class="card-body text-center">
                <h5 class="card-title">Kurulum Tamamlandı!</h5>
                <p class="card-text">
                    Reklam Yönetim Sistemi başarıyla kuruldu. Şimdi giriş yapabilirsiniz.
                </p>
                <a href="index.php" class="btn btn-primary">Giriş Yap</a>
            </div>
        </div>
        <?php endif; ?>
    </div>
    
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html> 