<?php
require_once 'config.php';
checkAuth();

// Get all payments with related data
try {
    $stmt = $db->query("
        SELECT p.*, c.amount as contract_amount, cu.company_name, cu.contact_name,
               au.name as unit_name, r.start_date, r.end_date
        FROM payments p
        JOIN contracts c ON p.contract_id = c.id
        JOIN reservations r ON c.reservation_id = r.id
        JOIN advertising_units au ON r.unit_id = au.id
        JOIN customers cu ON r.customer_id = cu.id
        ORDER BY p.payment_date DESC
    ");
    $payments = $stmt->fetchAll(PDO::FETCH_ASSOC);

    // Get contracts without payments
    $stmt = $db->query("
        SELECT c.*, r.start_date, r.end_date, au.name as unit_name, cu.company_name
        FROM contracts c
        JOIN reservations r ON c.reservation_id = r.id
        JOIN advertising_units au ON r.unit_id = au.id
        JOIN customers cu ON r.customer_id = cu.id
        LEFT JOIN payments p ON c.id = p.contract_id
        WHERE p.id IS NULL
        ORDER BY r.start_date
    ");
    $available_contracts = $stmt->fetchAll(PDO::FETCH_ASSOC);
} catch(PDOException $e) {
    echo "Error: " . $e->getMessage();
    $payments = [];
    $available_contracts = [];
}
?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Ödemeler - <?php echo SITE_NAME; ?></title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/boxicons@2.0.7/css/boxicons.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/flatpickr/dist/flatpickr.min.css">
    <style>
        .sidebar {
            min-height: 100vh;
            background: #343a40;
            color: white;
        }
        .nav-link {
            color: rgba(255,255,255,.8);
        }
        .nav-link:hover {
            color: white;
        }
        .card {
            border: none;
            border-radius: 10px;
            box-shadow: 0 0 10px rgba(0,0,0,.1);
        }
        .payment-card {
            transition: transform .2s;
        }
        .payment-card:hover {
            transform: translateY(-5px);
        }
    </style>
</head>
<body>
    <div class="container-fluid">
        <div class="row">
            <!-- Sidebar -->
            <div class="col-md-3 col-lg-2 px-0 sidebar">
                <div class="p-3">
                    <h4 class="text-center mb-4"><?php echo SITE_NAME; ?></h4>
                    <ul class="nav flex-column">
                        <li class="nav-item">
                            <a class="nav-link" href="dashboard.php">
                                <i class='bx bxs-dashboard'></i> Dashboard
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="units.php">
                                <i class='bx bxs-map'></i> Reklam Üniteleri
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="reservations.php">
                                <i class='bx bxs-calendar'></i> Rezervasyonlar
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="customers.php">
                                <i class='bx bxs-user-detail'></i> Müşteriler
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="contracts.php">
                                <i class='bx bxs-file'></i> Sözleşmeler
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link active" href="payments.php">
                                <i class='bx bxs-wallet'></i> Ödemeler
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="logout.php">
                                <i class='bx bxs-log-out'></i> Çıkış
                            </a>
                        </li>
                    </ul>
                </div>
            </div>

            <!-- Main Content -->
            <div class="col-md-9 col-lg-10 px-4 py-3">
                <div class="d-flex justify-content-between align-items-center mb-4">
                    <h2>Ödemeler</h2>
                    <button class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#addPaymentModal">
                        <i class='bx bx-plus'></i> Yeni Ödeme
                    </button>
                </div>

                <!-- Payments List -->
                <div class="row">
                    <?php foreach ($payments as $payment): ?>
                    <div class="col-md-4 mb-4">
                        <div class="card payment-card">
                            <div class="card-body">
                                <h5 class="card-title"><?php echo htmlspecialchars($payment['company_name']); ?></h5>
                                <p class="card-text">
                                    <strong>Ünite:</strong> <?php echo htmlspecialchars($payment['unit_name']); ?><br>
                                    <strong>Tutar:</strong> <?php echo number_format($payment['amount'], 2, ',', '.'); ?> TL<br>
                                    <strong>Ödeme Tarihi:</strong> <?php echo date('d.m.Y', strtotime($payment['payment_date'])); ?><br>
                                    <strong>Ödeme Yöntemi:</strong> <?php echo htmlspecialchars($payment['payment_method']); ?><br>
                                    <strong>Durum:</strong> 
                                    <span class="badge <?php echo $payment['payment_status'] == 'tamamlandi' ? 'bg-success' : ($payment['payment_status'] == 'beklemede' ? 'bg-warning' : 'bg-danger'); ?>">
                                        <?php echo $payment['payment_status'] == 'tamamlandi' ? 'Tamamlandı' : ($payment['payment_status'] == 'beklemede' ? 'Beklemede' : 'İptal'); ?>
                                    </span>
                                </p>
                                <div class="btn-group">
                                    <?php if ($payment['invoice_file']): ?>
                                    <a href="<?php echo htmlspecialchars($payment['invoice_file']); ?>" class="btn btn-sm btn-outline-primary" target="_blank">
                                        <i class='bx bx-download'></i> Fatura
                                    </a>
                                    <?php endif; ?>
                                    <button class="btn btn-sm btn-outline-danger" onclick="deletePayment(<?php echo $payment['id']; ?>)">
                                        <i class='bx bx-trash'></i> Sil
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
                    <?php endforeach; ?>
                </div>
            </div>
        </div>
    </div>

    <!-- Add Payment Modal -->
    <div class="modal fade" id="addPaymentModal" tabindex="-1">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Yeni Ödeme</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <form id="addPaymentForm">
                        <div class="mb-3">
                            <label class="form-label">Sözleşme</label>
                            <select class="form-select" name="contract_id" required>
                                <option value="">Seçiniz</option>
                                <?php foreach ($available_contracts as $contract): ?>
                                <option value="<?php echo $contract['id']; ?>">
                                    <?php echo htmlspecialchars($contract['unit_name']); ?> - 
                                    <?php echo htmlspecialchars($contract['company_name']); ?> 
                                    (<?php echo number_format($contract['amount'], 2, ',', '.'); ?> TL)
                                </option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                        <div class="mb-3">
                            <label class="form-label">Tutar (TL)</label>
                            <input type="number" class="form-control" name="amount" step="0.01" required>
                        </div>
                        <div class="mb-3">
                            <label class="form-label">Ödeme Tarihi</label>
                            <input type="text" class="form-control datepicker" name="payment_date" required>
                        </div>
                        <div class="mb-3">
                            <label class="form-label">Ödeme Yöntemi</label>
                            <select class="form-select" name="payment_method" required>
                                <option value="nakit">Nakit</option>
                                <option value="havale">Havale</option>
                                <option value="kredi_karti">Kredi Kartı</option>
                                <option value="cek">Çek</option>
                            </select>
                        </div>
                        <div class="mb-3">
                            <label class="form-label">Açıklama</label>
                            <textarea class="form-control" name="description" rows="3"></textarea>
                        </div>
                        <div class="mb-3">
                            <label class="form-label">Fatura</label>
                            <input type="file" class="form-control" name="invoice_file" accept=".pdf,.jpg,.jpeg,.png">
                        </div>
                    </form>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">İptal</button>
                    <button type="button" class="btn btn-primary" onclick="savePayment()">Kaydet</button>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/flatpickr"></script>
    <script src="https://cdn.jsdelivr.net/npm/flatpickr/dist/l10n/tr.js"></script>
    <script>
        // Initialize date pickers
        flatpickr(".datepicker", {
            locale: "tr",
            dateFormat: "Y-m-d",
            defaultDate: "today"
        });

        // Save payment function
        function savePayment() {
            const form = document.getElementById('addPaymentForm');
            const formData = new FormData(form);
            
            fetch('api/payments.php', {
                method: 'POST',
                body: formData
            })
            .then(response => response.json())
            .then(data => {
                if (data.id) {
                    location.reload();
                } else {
                    alert('Ödeme eklenirken bir hata oluştu.');
                }
            })
            .catch(error => {
                console.error('Error:', error);
                alert('Ödeme eklenirken bir hata oluştu.');
            });
        }

        // Delete payment function
        function deletePayment(id) {
            if (confirm('Bu ödemeyi silmek istediğinizden emin misiniz?')) {
                fetch(`api/payments.php?id=${id}`, {
                    method: 'DELETE'
                })
                .then(response => response.json())
                .then(data => {
                    if (data.success) {
                        location.reload();
                    } else {
                        alert('Ödeme silinirken bir hata oluştu.');
                    }
                })
                .catch(error => {
                    console.error('Error:', error);
                    alert('Ödeme silinirken bir hata oluştu.');
                });
            }
        }
    </script>
</body>
</html> 