<?php
require_once 'config.php';
checkAuth();

// Get all reservations with related data
try {
    $stmt = $db->query("
        SELECT r.*, au.name as unit_name, au.type as unit_type, c.company_name, c.contact_name
        FROM reservations r
        JOIN advertising_units au ON r.unit_id = au.id
        JOIN customers c ON r.customer_id = c.id
        ORDER BY r.start_date DESC
    ");
    $reservations = $stmt->fetchAll(PDO::FETCH_ASSOC);

    // Get available units for the form
    $stmt = $db->query("SELECT id, name, type FROM advertising_units WHERE status = 'available'");
    $available_units = $stmt->fetchAll(PDO::FETCH_ASSOC);

    // Get all customers for the form
    $stmt = $db->query("SELECT id, company_name FROM customers ORDER BY company_name");
    $customers = $stmt->fetchAll(PDO::FETCH_ASSOC);
} catch(PDOException $e) {
    echo "Error: " . $e->getMessage();
    $reservations = [];
    $available_units = [];
    $customers = [];
}
?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Rezervasyonlar - <?php echo SITE_NAME; ?></title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/boxicons@2.0.7/css/boxicons.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/flatpickr/dist/flatpickr.min.css">
    <style>
        .sidebar {
            min-height: 100vh;
            background: #343a40;
            color: white;
        }
        .nav-link {
            color: rgba(255,255,255,.8);
        }
        .nav-link:hover {
            color: white;
        }
        .card {
            border: none;
            border-radius: 10px;
            box-shadow: 0 0 10px rgba(0,0,0,.1);
        }
        .reservation-card {
            transition: transform .2s;
        }
        .reservation-card:hover {
            transform: translateY(-5px);
        }
    </style>
</head>
<body>
    <div class="container-fluid">
        <div class="row">
            <!-- Sidebar -->
            <div class="col-md-3 col-lg-2 px-0 sidebar">
                <div class="p-3">
                    <h4 class="text-center mb-4"><?php echo SITE_NAME; ?></h4>
                    <ul class="nav flex-column">
                        <li class="nav-item">
                            <a class="nav-link" href="dashboard.php">
                                <i class='bx bxs-dashboard'></i> Dashboard
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="units.php">
                                <i class='bx bxs-map'></i> Reklam Üniteleri
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link active" href="reservations.php">
                                <i class='bx bxs-calendar'></i> Rezervasyonlar
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="customers.php">
                                <i class='bx bxs-user-detail'></i> Müşteriler
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="contracts.php">
                                <i class='bx bxs-file'></i> Sözleşmeler
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="logout.php">
                                <i class='bx bxs-log-out'></i> Çıkış
                            </a>
                        </li>
                    </ul>
                </div>
            </div>

            <!-- Main Content -->
            <div class="col-md-9 col-lg-10 px-4 py-3">
                <div class="d-flex justify-content-between align-items-center mb-4">
                    <h2>Rezervasyonlar</h2>
                    <button class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#addReservationModal">
                        <i class='bx bx-plus'></i> Yeni Rezervasyon
                    </button>
                </div>

                <!-- Reservations List -->
                <div class="row">
                    <?php foreach ($reservations as $reservation): ?>
                    <div class="col-md-4 mb-4">
                        <div class="card reservation-card">
                            <div class="card-body">
                                <h5 class="card-title"><?php echo htmlspecialchars($reservation['unit_name']); ?></h5>
                                <p class="card-text">
                                    <strong>Müşteri:</strong> <?php echo htmlspecialchars($reservation['company_name']); ?><br>
                                    <strong>İletişim:</strong> <?php echo htmlspecialchars($reservation['contact_name']); ?><br>
                                    <strong>Başlangıç:</strong> <?php echo date('d.m.Y', strtotime($reservation['start_date'])); ?><br>
                                    <strong>Bitiş:</strong> <?php echo date('d.m.Y', strtotime($reservation['end_date'])); ?><br>
                                    <strong>Durum:</strong> 
                                    <span class="badge <?php echo $reservation['status'] == 'active' ? 'bg-success' : ($reservation['status'] == 'completed' ? 'bg-info' : 'bg-danger'); ?>">
                                        <?php echo $reservation['status'] == 'active' ? 'Aktif' : ($reservation['status'] == 'completed' ? 'Tamamlandı' : 'İptal Edildi'); ?>
                                    </span>
                                </p>
                                <div class="btn-group">
                                    <button class="btn btn-sm btn-outline-primary" onclick="editReservation(<?php echo $reservation['id']; ?>)">
                                        <i class='bx bx-edit'></i> Düzenle
                                    </button>
                                    <button class="btn btn-sm btn-outline-danger" onclick="deleteReservation(<?php echo $reservation['id']; ?>)">
                                        <i class='bx bx-trash'></i> Sil
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
                    <?php endforeach; ?>
                </div>
            </div>
        </div>
    </div>

    <!-- Add Reservation Modal -->
    <div class="modal fade" id="addReservationModal" tabindex="-1">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Yeni Rezervasyon</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <form id="addReservationForm">
                        <div class="mb-3">
                            <label class="form-label">Reklam Ünitesi</label>
                            <select class="form-select" name="unit_id" required>
                                <option value="">Seçiniz</option>
                                <?php foreach ($available_units as $unit): ?>
                                <option value="<?php echo $unit['id']; ?>">
                                    <?php echo htmlspecialchars($unit['name']); ?> (<?php echo htmlspecialchars($unit['type']); ?>)
                                </option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                        <div class="mb-3">
                            <label class="form-label">Müşteri</label>
                            <select class="form-select" name="customer_id" required>
                                <option value="">Seçiniz</option>
                                <?php foreach ($customers as $customer): ?>
                                <option value="<?php echo $customer['id']; ?>">
                                    <?php echo htmlspecialchars($customer['company_name']); ?>
                                </option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                        <div class="mb-3">
                            <label class="form-label">Başlangıç Tarihi</label>
                            <input type="text" class="form-control datepicker" name="start_date" required>
                        </div>
                        <div class="mb-3">
                            <label class="form-label">Bitiş Tarihi</label>
                            <input type="text" class="form-control datepicker" name="end_date" required>
                        </div>
                    </form>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">İptal</button>
                    <button type="button" class="btn btn-primary" onclick="saveReservation()">Kaydet</button>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/flatpickr"></script>
    <script src="https://cdn.jsdelivr.net/npm/flatpickr/dist/l10n/tr.js"></script>
    <script>
        // Initialize date pickers
        flatpickr(".datepicker", {
            locale: "tr",
            dateFormat: "Y-m-d",
            minDate: "today"
        });

        // Save reservation function
        function saveReservation() {
            const form = document.getElementById('addReservationForm');
            const formData = new FormData(form);
            
            fetch('api/reservations.php', {
                method: 'POST',
                body: JSON.stringify(Object.fromEntries(formData)),
                headers: {
                    'Content-Type': 'application/json'
                }
            })
            .then(response => response.json())
            .then(data => {
                if (data.id) {
                    location.reload();
                } else {
                    alert('Rezervasyon eklenirken bir hata oluştu.');
                }
            })
            .catch(error => {
                console.error('Error:', error);
                alert('Rezervasyon eklenirken bir hata oluştu.');
            });
        }

        // Edit reservation function
        function editReservation(id) {
            // Add edit functionality
        }

        // Delete reservation function
        function deleteReservation(id) {
            if (confirm('Bu rezervasyonu silmek istediğinizden emin misiniz?')) {
                fetch(`api/reservations.php?id=${id}`, {
                    method: 'DELETE'
                })
                .then(response => response.json())
                .then(data => {
                    if (data.success) {
                        location.reload();
                    } else {
                        alert('Rezervasyon silinirken bir hata oluştu.');
                    }
                })
                .catch(error => {
                    console.error('Error:', error);
                    alert('Rezervasyon silinirken bir hata oluştu.');
                });
            }
        }
    </script>
</body>
</html> 