<?php
require_once 'config.php';
checkAuth();

// Get all advertising units
try {
    $stmt = $db->query("SELECT * FROM advertising_units ORDER BY type, name");
    $units = $stmt->fetchAll(PDO::FETCH_ASSOC);
} catch(PDOException $e) {
    echo "Error: " . $e->getMessage();
    $units = [];
}
?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Reklam Üniteleri - <?php echo SITE_NAME; ?></title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/boxicons@2.0.7/css/boxicons.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://unpkg.com/leaflet@1.7.1/dist/leaflet.css" />
    <style>
        .sidebar {
            min-height: 100vh;
            background: #343a40;
            color: white;
        }
        .nav-link {
            color: rgba(255,255,255,.8);
        }
        .nav-link:hover {
            color: white;
        }
        .card {
            border: none;
            border-radius: 10px;
            box-shadow: 0 0 10px rgba(0,0,0,.1);
        }
        #map {
            height: 500px;
            border-radius: 10px;
        }
        .unit-card {
            transition: transform .2s;
        }
        .unit-card:hover {
            transform: translateY(-5px);
        }
    </style>
</head>
<body>
    <div class="container-fluid">
        <div class="row">
            <!-- Sidebar -->
            <div class="col-md-3 col-lg-2 px-0 sidebar">
                <div class="p-3">
                    <h4 class="text-center mb-4"><?php echo SITE_NAME; ?></h4>
                    <ul class="nav flex-column">
                        <li class="nav-item">
                            <a class="nav-link" href="dashboard.php">
                                <i class='bx bxs-dashboard'></i> Dashboard
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link active" href="units.php">
                                <i class='bx bxs-map'></i> Reklam Üniteleri
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="reservations.php">
                                <i class='bx bxs-calendar'></i> Rezervasyonlar
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="customers.php">
                                <i class='bx bxs-user-detail'></i> Müşteriler
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="contracts.php">
                                <i class='bx bxs-file'></i> Sözleşmeler
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="logout.php">
                                <i class='bx bxs-log-out'></i> Çıkış
                            </a>
                        </li>
                    </ul>
                </div>
            </div>

            <!-- Main Content -->
            <div class="col-md-9 col-lg-10 px-4 py-3">
                <div class="d-flex justify-content-between align-items-center mb-4">
                    <h2>Reklam Üniteleri</h2>
                    <button class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#addUnitModal">
                        <i class='bx bx-plus'></i> Yeni Ünite Ekle
                    </button>
                </div>

                <!-- Map -->
                <div class="card mb-4">
                    <div class="card-body">
                        <div id="map"></div>
                    </div>
                </div>

                <!-- Units List -->
                <div class="row">
                    <?php foreach ($units as $unit): ?>
                    <div class="col-md-4 mb-4">
                        <div class="card unit-card">
                            <div class="card-body">
                                <h5 class="card-title"><?php echo htmlspecialchars($unit['name']); ?></h5>
                                <p class="card-text">
                                    <strong>Tür:</strong> <?php echo htmlspecialchars($unit['type']); ?><br>
                                    <strong>Konum:</strong> <?php echo htmlspecialchars($unit['location']); ?><br>
                                    <strong>Durum:</strong> 
                                    <span class="badge <?php echo $unit['status'] == 'available' ? 'bg-success' : 'bg-warning'; ?>">
                                        <?php echo $unit['status'] == 'available' ? 'Müsait' : 'Dolu'; ?>
                                    </span>
                                </p>
                                <div class="btn-group">
                                    <button class="btn btn-sm btn-outline-primary" onclick="editUnit(<?php echo $unit['id']; ?>)">
                                        <i class='bx bx-edit'></i> Düzenle
                                    </button>
                                    <button class="btn btn-sm btn-outline-danger" onclick="deleteUnit(<?php echo $unit['id']; ?>)">
                                        <i class='bx bx-trash'></i> Sil
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
                    <?php endforeach; ?>
                </div>
            </div>
        </div>
    </div>

    <!-- Add Unit Modal -->
    <div class="modal fade" id="addUnitModal" tabindex="-1">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Yeni Reklam Ünitesi Ekle</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <form id="addUnitForm">
                        <div class="mb-3">
                            <label class="form-label">Ünite Türü</label>
                            <select class="form-select" name="type" required>
                                <option value="billboard">Billboard</option>
                                <option value="billboard_plus">Billboard Plus</option>
                                <option value="megalight">Megalight</option>
                                <option value="clp">CLP</option>
                            </select>
                        </div>
                        <div class="mb-3">
                            <label class="form-label">Ünite Adı</label>
                            <input type="text" class="form-control" name="name" required>
                        </div>
                        <div class="mb-3">
                            <label class="form-label">Konum</label>
                            <input type="text" class="form-control" name="location" required>
                        </div>
                        <div class="mb-3">
                            <label class="form-label">Açıklama</label>
                            <textarea class="form-control" name="description" rows="3"></textarea>
                        </div>
                    </form>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">İptal</button>
                    <button type="button" class="btn btn-primary" onclick="saveUnit()">Kaydet</button>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script src="https://unpkg.com/leaflet@1.7.1/dist/leaflet.js"></script>
    <script>
        // Initialize map
        const map = L.map('map').setView([41.0082, 28.9784], 10);
        L.tileLayer('https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png', {
            attribution: '© OpenStreetMap contributors'
        }).addTo(map);

        // Add markers for each unit
        <?php foreach ($units as $unit): ?>
        L.marker([<?php echo $unit['latitude']; ?>, <?php echo $unit['longitude']; ?>])
            .bindPopup('<?php echo htmlspecialchars($unit['name']); ?>')
            .addTo(map);
        <?php endforeach; ?>

        // Save unit function
        function saveUnit() {
            const form = document.getElementById('addUnitForm');
            const formData = new FormData(form);
            
            // Add AJAX call here to save the unit
            // After successful save, reload the page
            location.reload();
        }

        // Edit unit function
        function editUnit(id) {
            // Add edit functionality
        }

        // Delete unit function
        function deleteUnit(id) {
            if (confirm('Bu üniteyi silmek istediğinizden emin misiniz?')) {
                // Add AJAX call here to delete the unit
                // After successful delete, reload the page
                location.reload();
            }
        }
    </script>
</body>
</html> 